/**
 * Created by brian on 20/12/2016.
 */
Flip(function () {
  Flip.animate({
    selector: ' ',
    duration: 1,
    infinite: true,
    css: {
      '.top-bg': () => ({
        minHeight: parseInt(document.documentElement.clientHeight * .76) + 'px'
      }),
      'bottom-bg': () => ({
        minHeight: parseInt(document.documentElement.clientHeight * .24) + 'px'
      })
    }
  });
  Flip.animate({
    delay: 0,
    duration: 0.001,
    onStart(){
      toggleClass(document.body, 's1', false);
      toggleClass('.toolbar', 'hide', true);
    }
  }).then(() => Flip.animate({
    duration: .6,
    delay: .2,
      selector: '.tip.v1',
      ease: Flip.EASE.sineInOut,
      variables: {
        x0: [100, 0]
      },
      css(css, param){
        css['-webkit-clip-path'] = css.clipPath = makeClipRect(param.x0, 100);
      },
      onStart(){
        toggleClass('.video', 'shadow', true);
        toggleClass('.tip.v1', 'hide', false)
      }
    }
  )).then(() => Flip.animate({
    duration: .3,
      selector: '.toolbar .container',
      ease: Flip.EASE.quadOut,
      variables: {
        x0: [50, 0],
        x1: [50, 100]
      },
      css(css, param){
        css['-webkit-clip-path'] = css.clipPath = makeClipRect(param.x0, param.x1);
      },
      onStart(){
        toggleClass(Flip.$('.toolbar'), 'hide', false);
      },
      onEnd(){
        let toolbar = Flip.$('.toolbar');
        toggleClass(toolbar, 'light', false);
        toggleClass(toolbar, 'dark', true);
        toggleClass(toolbar, 'shadow', true);
      }
    })
  ).then(() => Flip.animate({
    duration: .6,
    delay: .2,
    selector: '.tip.v2',
    onStart(){
      toggleClass('.tip.v2', 'hide', false);
    },
    variables: {
      x1: [0, 100]
    },
    css(css, param){
      css['-webkit-clip-path'] = css.clipPath = makeClipRect(0, param.x1);
    }
  })).then(() => Flip.animate({
    duration: .6,
    selector: '.down-arrow',
    onStart(){
      toggleClass('.down-arrow', 'hide', false);
    },
    variables: {
      dy: [-80, 0],
      opacity: [0.3, 1]
    },
    css(css, param){
      css.opacity = param.opacity;
    },
    transform(mat, param){
      mat.translate(0, param.dy);
    }
  })).then(() => Flip.animate({
    duration: .6,
    delay: .2,
    selector: '.tip.v3',
    onStart(){
      toggleClass('.tip.v3', 'hide', false);
    },
    variables: {
      x1: [0, 100]
    },
    css(css, param){
      css['-webkit-clip-path'] = css.clipPath = makeClipRect(0, param.x1);
    }
  })).then(() => [
    {
      duration: .3,
      selector: '.tip.v3,.tip.v2',
      variables: {
        x1: [100, 0]
      },
      css(css, param){
        css['-webkit-clip-path'] = css.clipPath = makeClipRect(0, param.x1)
      },
      onEnd(){
        ['.tip.v2', '.tip.v3'].forEach(sel => toggleClass(sel, 'hide', true));
      }
    }, {
      duration: .3,
      selector: '.tip.v1',
      variables: {
        x1: [0, 100]
      },
      css(css, param){
        css['-webkit-clip-path'] = css.clipPath = makeClipRect(param.x1, 100)
      },
      onEnd(){
        toggleClass('.tip.v1', 'hide', true);
      }
    },
    {
      duration: .3,
      selector: '.down-arrow',
      variables: {
        opacity: [1, 0]
      },
      css(css, param){
        css.opacity = param.opacity;
      },
      onEnd(){
        toggleClass('.down-arrow', 'hide', true);
      }
    }
  ].map(Flip.animate)).then(() => Flip.animate({
    duration: .4,
    delay: .2,
    infinite: true,
    selector: '.right-arrow img',
    reverse: true,
    onStart(){
      toggleClass(document.body, 's3', false);
    },
    variables: {
      dx: [-5, 5]
    },
    transform(mat, param){
      mat.translate(param.dx, 0).rotate(-Math.PI / 2);
    }
  }))
});
function makeClipRect(x0, x1) {
  x0 = Math.round(x0);
  x1 = Math.round(x1);
  return `polygon(${x0}% 0,${x1}% 0%,${x1}% 100%,${x0}% 100%)`;
}
function toggleClass(ele, className, has) {
  if (typeof ele === "string") {
    ele = Flip.$(ele);
  }
  ele.classList[has ? 'add' : 'remove'](className);
}